<?php
include_once(DCS_DIVICAROUSEL_PATH.'/includes/modules/base/base.php');
class DCS_ImageCarouselItem extends ET_Builder_Module {

	public $slug       	    = 'divi8_image_carousel_item';
	public $vb_support      = 'on';
	public $type            = 'child';
	public $child_title_var = 'heading';
	public $child_title_fallback_var = 'description';


	protected $module_credits = array(
		'module_uri' => 'https://divicarousels.com/divi-image-carousel/',
		'author'     => 'DiviCarousel',
		'author_uri' => 'https://divicarousels.com/',
	);

	public function init() {
		$this->name = esc_html__( 'Carousel Item', 'dcs-divicarousel' );
		$this->settings_modal_toggles = array(
			'advanced' => array(
				'toggles' => array(
					'divi8_image_content_carousel_item_settings' => esc_html__( 'Slide Item', 'divi8-divicarousel8'),
					'divi8_image_content_carousel_text_all_settings' => esc_html__( 'Heading', 'divi8-divicarousel8'),
					'divi8_image_content_carousel_content_all_settings' => esc_html__( 'Sub Heading', 'divi8-divicarousel8'),
					'divi8_image_content_carousel_image_all_settings' => array('title' => esc_html__( 'Image Settings', 'divi8-divicarousel8'),),
					
				)
			)
	);
	}   
	public function get_advanced_fields_config() {
        return array(
            'text'  => false,
            'fonts' => array(
                'text' => array(
                    'css' => array(
                        'main' => '%%order_class%% .carousel_content span',
						'important' => 'all'
                    ),
                    'toggle_slug' => 'divi8_image_content_carousel_text_all_settings'
                ),
                'content' => array(
                    'css' => array(
                        'main' => '%%order_class%% .carousel_content p',
						'important' => 'all'
                    ),
                    'toggle_slug' => 'divi8_image_content_carousel_content_all_settings'
                )
            ),
            'background' => array(
                'settings' => array(
                    'color' => 'alpha',
                ),
                'css'   => array(
                    'main' => "%%order_class%% .swiper-container",
                    'important' => 'all'
                )
            ),
            'max_width' => false,
            'borders' => array(
                'default' => array(
                    'css'          => array(
						'main' => array(
							'border_radii'  => '%%order_class%% .swiper-container .carousel_content',
							'border_styles' => '%%order_class%% .swiper-container .carousel_content',
                        ),
                    ),
                ),
                'image_border'   => array(
					'css'          => array(
						'main' => array(
							'border_radii'  => '%%order_class%% .carousel_content img',
							'border_styles' => '%%order_class%% .carousel_content img',
                        ),
                    ),
					'label_prefix' => esc_html__( 'Image', 'divi8-divicarousel8' ),
					'tab_slug'     => 'advanced',
					'toggle_slug'  => 'divi8_image_content_carousel_image_all_settings',
                ),
				
				'item_border'   => array(
					'css'          => array(
						'main' => array(
							'border_radii'  => '%%order_class%% .carousel_content',
							'border_styles' => '%%order_class%% .carousel_content',
                        ),
                    ),
					'label_prefix' => esc_html__( 'Item Border', 'divi8-divicarousel8' ),
					'tab_slug'     => 'advanced',
					'toggle_slug'  => 'divi8_image_content_carousel_item_settings',
                ),
                'text_border'   => array(
					'css'          => array(
						'main' => array(
							'border_radii'  => '%%order_class%% .divi8_image_heading',
							'border_styles' => '%%order_class%% .divi8_image_heading',
                        ),
                    ),
					'label_prefix' => esc_html__( 'Text', 'divi8-divicarousel8' ),
					'tab_slug'     => 'advanced',
					'toggle_slug'  => 'divi8_image_content_carousel_text_all_settings',
                ),
                'content_border'   => array(
					'css'          => array(
						'main' => array(
							'border_radii'  => '%%order_class%% .carousel_content p',
							'border_styles' => '%%order_class%% .carousel_content p',
                        ),
                    ),
					'label_prefix' => esc_html__( 'Content', 'divi8-divicarousel8' ),
					'tab_slug'     => 'advanced',
					'toggle_slug'  => 'divi8_image_content_carousel_content_all_settings',
				),
            ),
			'box_shadow' => array(
                'default' => array(
                    'css' => array(
                        'main' => '%%order_class%% .carousel_content',
                        'important' => 'all',
                    ),
                ),
                'item' => array(
                    'label_prefix' => esc_html__("Item Box Shadow", 'divi8-divicarousel8'),
                    'css' => array(
                        'main' => '%%order_class%% .carousel_content',
                        'important' => 'all',
                    ),
                    'toggle_slug' => 'divi8_image_content_carousel_item_settings'
                ),
				'image_box_shadow' => array(
                    'css'          => array(
                        'main' => '%%order_class%% .carousel_content img ',
                        'important' => 'all'
                    ),
					'label_prefix' => esc_html__( 'Image', 'divi8-divicarousel8' ),
					'tab_slug'     => 'advanced',
					'toggle_slug'  => 'divi8_image_content_carousel_image_all_settings',
                ),
            ),
            'margin_padding' => array(
                'css' => array(
                    'main' => '%%order_class%% .carousel_content',
                ),
                'important' => 'all',
            ),
            'background' => array(
                'settings' => array(
                    'color' => 'alpha',
                ),
                'css' => array(
                    'main' => "%%order_class%% .carousel_content",
                    'important' => 'all',
                ),
            ),
        );
    }

	public function get_fields() {
		$fields = [];
		$fields['heading'] = [
			'label' => esc_html__( "Heading", 'divi8-divicarousel8'  ),
			'type' => 'text',
			'default' => 'Heading',
		];
		$fields["description"] = [
			'label' => esc_html__( "Sub Heading", 'divi8-divicarousel8'  ),
			'type' => 'text',
			'default' => esc_html('Sub Heading'),
		];
		$fields['img'] = [
			'label' => esc_html__( "Image", 'divi8-divicarousel8'  ),
			'type' => 'upload',
			'upload_button_text' => esc_attr__( 'Upload an image', 'divi8-divicarousel8' ),
			'choose_text' => esc_attr__( 'Choose an image', 'divi8-divicarousel8' ),
			'data_type' => 'image',
			'default' => 'data:image/svg+xml;base64,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',
		];
		$fields['img_alt'] = [
			'label' => esc_html__( "Image Alt", 'divi8-divicarousel8'  ),
			'type' => 'text',
			'description'     => esc_html__( 'Input your desired img alt text here.', 'divi8-divicarousel8' ),
			'default' => '',
		];
		// Content Positions
		$fields['divi8_image_content_position'] = [
			'label' => esc_html__( "Text Position", 'divi8-divicarousel8'  ),
			'type'            => 'select',
			'options' => array(
				'top' => esc_html__('Top', 'divi8-divicarousel8'),
				'bottom' => esc_html__('Bottom', 'divi8-divicarousel8'),
				'middle' => esc_html__('Center', 'divi8-divicarousel8'),
				'outside' => esc_html__('Outside', 'divi8-divicarousel8'),
				'none' => esc_html__('None', 'divi8-divicarousel8'),
			),
			'default_on_front' => 'bottom',
		];
		return $fields;
	}

	public function render($attrs, $content = null , $render_slug) {
		$divi8_image_content_position = strip_tags($this->props["divi8_image_content_position"]);
		$description = strip_tags($this->props["description"]);
		$heading = strip_tags($this->props["heading"]);
		$img = strip_tags($this->props["img"]);
		$img_alt = $this->props["img_alt"];

		if($divi8_image_content_position === 'top'){
			$output_carousel = '<div class="carousel_content img_caro">
					<img src=" ' . $img . ' " alt=" ' . $img_alt . ' ">
					<div class="img_caro_top img_caro_text">
						<span>' . $heading . '</span>
						<p> ' . $description . '</p>
					</div>
				</div>';
		}else if($divi8_image_content_position === 'bottom'){
			$output_carousel = '<div class="carousel_content img_caro">
					<img src=" ' . $img . ' " alt=" ' . $img_alt . ' ">
					<div class="img_caro_bottom img_caro_text">
						<span>' . $heading . '</span>
						<p> ' . $description . '</p>
					</div>
				</div>';
		}else if($divi8_image_content_position === 'middle'){
			$output_carousel = '<div class="carousel_content img_caro">
					<img src=" ' . $img . ' " alt=" ' . $img_alt . ' ">
					<div class="img_caro_middle img_caro_text">
						<span>' . $heading . '</span>
						<p> ' . $description . '</p>
					</div>
				</div>';
		}else if($divi8_image_content_position === 'outside'){
			
			$output_carousel = '<div class="carousel_content img_caro">
					<img src=" ' . $img . ' " alt=" ' . $img_alt . ' ">
					<div class="img_caro_outside img_caro_text">
						<span>' . $heading . '</span>
						<p> ' . $description . '</p>
					</div>
				</div>';
		}else if($divi8_image_content_position === 'none'){
			
			$output_carousel = '<div class="carousel_content img_caro">
					<img src=" ' . $img . ' " alt=" ' . $img_alt . ' ">
				</div>';
		}
				
		return sprintf(
			'<div> %1$s </div>', $output_carousel
		);

	}
}

new DCS_ImageCarouselItem;